﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessAHOBPR;
using PS = VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;
using WCF_BusinessManagerAHOBPRTests.EMIS;

namespace WCF_BusinessManagerAHOBPRTests
{
    [TestClass]
    public class DoDDeploymentImporterTests : DeploymentFactoryTestBase
    {
        private DoDDeploymentImporter _cut;

        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new DoDDeploymentImporter();
        }
        #region tests
        [TestMethod()]
        public void CreateNewDateRange_Should_Return_DeploymentEndDate_Of_11_11_9999_For_Active_Duty_Registrant()
        {
            DateTime start = DateTime.Parse("2003-08-20");
            var ep = new MilitaryServiceEpisode();
            var data = new MilitaryServiceEpisodeData();
            data.serviceEpisodeStartDate = start;
            data.serviceEpisodeEndDate = DateTime.Parse("01-01-0001");
            ep.militaryServiceEpisodeData = data;
            var expected = new DateRange(start, DateTime.Parse("11-11-9999"));
            var actual = AHOBPRShared.CreateNewDateRange(data.serviceEpisodeStartDate, data.serviceEpisodeEndDate);
            Assert.AreEqual(expected.End, actual.End);
        }

        //[TestMethod()]
        //public void GetBranchOfService_With_Army_BoS_Episode()
        //{
        //    var deploymentStart = DateTime.Parse("2003-08-20");
        //    var deploymentEnd = DateTime.Parse("2010-08-13");
        //    Dictionary<DateRange, string> svcEpisodes = CreateSvcDateRange();
        //    var actual = AHOBPRShared.GetBranchOfServiceFromDateRange(deploymentStart, deploymentEnd, svcEpisodes);
        //    Assert.AreEqual("Army", actual);
        //}

        //[TestMethod()]
        //public void GetBranchOfService_With_Invalid_BoSEpisode_Should_Return_99()
        //{
        //    var deploymentStart = DateTime.Parse("1776-07-04");
        //    var deploymentEnd = DateTime.Parse("1781-10-19");
        //    //Surrender at Yorktown. In case you're wondering
        //    var svcEpisodeStart = DateTime.Parse("2003-08-20");
        //    var svcEpisodeEnd = DateTime.Parse("2010-08-13");
        //    var svcDateRange = new DateRange(svcEpisodeStart, svcEpisodeEnd);
        //    Dictionary<DateRange, string> svcEpisodes = new Dictionary<DateRange, string> { { svcDateRange, "A" } };

        //    string actual = AHOBPRShared.GetBranchOfServiceFromDateRange(deploymentStart, deploymentEnd, svcEpisodes);
        //    Assert.AreEqual("Unknown", actual);
        //}

        [TestMethod()]
        public void SetRegistrantDeployments_Test()
        {
            string edipi = "1068619536";
            var history = new RegistrantHistory();

            var payPlan =  new Dictionary<DateTime, PS.PayGradeHistoryData>
            {
                { DateTime.Parse("2009-11-15"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "05",
                    serviceRankNameTxt = "Sergeant",
                    serviceRankNameCode = "SGT",
                    payGradeDate = DateTime.Parse("2009-11-15")
                } }
            };

            var occupations =  new SortedDictionary<DateTime, List<ServiceSpecificOccupation>>{
                { DateTime.Parse("3/31/2014 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 12638, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'P'}
                               ,new ServiceSpecificOccupation{OccupationId = 12767, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'S'}
                    }
                } };
            var svcEpisodeStart = DateTime.Parse("2010-08-20");
            var svcEpisodeEnd = DateTime.Parse("2015-08-13");
            var svcDateRange = new DateRange(svcEpisodeStart, svcEpisodeEnd);
            Dictionary<DateRange, string> svcEpisodes = new Dictionary<DateRange, string> { { svcDateRange, "A" } };
            history.BranchesOfService = svcEpisodes;
            history.OccupationsByDateTime = occupations;
            history.PaymentDataByDateTime = payPlan;
            // MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = _cut.GetRegistrantDeployments(history, edipi, factory);
            Assert.IsNotNull(actual);
            //In Registrant edipi 1068619536 currently has 6 deployments in Emis
            Assert.AreEqual(6, actual.Count);

        }    

        [TestMethod()]
        public void TypeTest()
        {
            var assembly = Assembly.GetAssembly(typeof(AHOBPRBaseBO));
            var importer = new BprDoDDeploymentImporter();
            Type type = assembly.GetType("VeteransAffairs.Registries.BusinessManagerAHOBPR.BprDoDDeploymentImporter");
            IDeploymentImporter actual = Activator.CreateInstance(type) as IDeploymentImporter;
            Assert.IsInstanceOfType(actual, typeof(BprDoDDeploymentImporter));
        }

        #endregion

        #region SampleData    
        ///// <summary>
        ///// ServiceEpisode Start: 2003-08-20 End: 2010-08-13 Branch: A
        ///// </summary>
        ///// <returns></returns>
        //private Dictionary<DateRange, string> CreateSvcDateRange()
        //{
        //    var svcEpisodeStart = DateTime.Parse("2003-08-20");
        //    var svcEpisodeEnd = DateTime.Parse("2010-08-13");
        //    var svcDateRange = new DateRange(svcEpisodeStart, svcEpisodeEnd);
        //    Dictionary<DateRange, string> svcEpisodes = new Dictionary<DateRange, string> { { svcDateRange, "A" } };
        //    return svcEpisodes;
        //}
        #endregion
    }
}
